<?php
namespace WPT\DiviGravity;

use WPTools\Pimple\Container;

/**
 * Container
 */
class Loader extends Container
{
    /**
     *
     * @var mixed
     */
    public static $instance;

    public function __construct()
    {
        parent::__construct();

        $this['bootstrap'] = function ($container) {
            return new WP\Bootstrap($container);
        };

        $this['divi'] = function ($container) {
            return new Divi\Divi($container);
        };

        $this['margin_padding'] = function ($container) {
            return new Divi\MarginPadding($container);
        };

        $this['gravityform'] = function ($container) {
            return new GravityForm\GravityForm($container);
        };

        $this['gf_divi_fields'] = function ($container) {
            return new \WPT_Divi_Gravity_Modules\GravityFormModule\Fields($container);
        };
    }

    /**
     * Get container instance.
     */
    public static function get_instance()
    {
        if (!self::$instance) {
            self::$instance = new Loader();
        }

        return self::$instance;
    }

    /**
     * Plugin run
     */
    public function run()
    {
        // activation hook
        register_activation_hook($this['file'], [$this['bootstrap'], 'register_activation_hook']);

        //divi actions
        add_action('et_builder_ready', [$this['divi'], 'et_builder_ready'], 1);
        add_action('divi_extensions_init', [$this['divi'], 'divi_extensions_init']);

        add_action('wp_enqueue_scripts', [$this['divi'], 'enqueue_divi_module_assets']);
        add_action('admin_head', [$this['bootstrap'], 'admin_head']);

        $loader = $this;
        //admin menu
        add_action(
            'admin_menu',
            function () use ($loader) {
                add_submenu_page(
                    'et_divi_options',
                    'Divi Gravity Form',
                    'Divi Gravity Form',
                    'manage_options',
                    $loader['slug'],
                    function () use ($loader) {
                        ob_start();
                        require $loader['dir'] . '/resources/views/sub_menu.php';
                        // phpcs:ignore
                        echo ob_get_clean();
                    }
                );
            },
            99
        );

        add_action('wp_print_styles', function () {
            wp_dequeue_style('et_pb_wpt_gravityform-styles');
        });

        add_filter('gform_submit_button', [$this['gravityform'], 'gform_submit_button__premium_only'], 10, 2);
        add_filter('gform_next_button', [$this['gravityform'], 'gform_next_button__premium_only'], 10, 2);
        add_filter('gform_previous_button', [$this['gravityform'], 'gform_previous_button__premium_only'], 10, 2);

        // to get sticky scroll works. adding to valid slug.
        add_filter('et_builder_get_module_slugs_by_post_type', function (
            $slugs,
            $post_type
        ) {
            if (!in_array('et_pb_wpt_gravityform', $slugs)) {
                $slugs[] = 'et_pb_wpt_gravityform';
            }

            return $slugs;

        }, 99, 2);
    }
}
