<?php
namespace WPT_Divi_Gravity_Modules\GravityFormModule;

use ET_Builder_Module;
use ET_Builder_Element;

/**
 * GravityFormModule.
 */
class GravityFormModule extends ET_Builder_Module
{
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Gravity Form';

    public $slug = 'et_pb_wpt_gravityform';

    public $vb_support = 'on';

    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->module_credits = [
            'module_uri' => 'https://wptools.app/wordpress-plugin/gravity-forms-divi-module/',
            'author'     => 'WP Tools',
            'author_uri' => 'https://wptools.app/wordpress-plugin/gravity-forms-divi-module/',
        ];

        $this->container = $container;
        $this->icon_path = $this->container['url'] . '/images/gravity-forms.svg';
        $this->container['gf_divi_fields']->set_module($this);
        parent::__construct();
    }

    /**
     * Premium advanced fields
     *
     * @return [type] [description]
     */
    public function get_advanced_fields_config()
    {
        return [
            'button'         => [
                'form_button'     => [
                    'label'         => 'Button',
                    'css'           => [
                        'main'       => $this->container['gf_divi_fields']->get_selector('button'),
                        'text_color' => $this->container['gf_divi_fields']->get_selector('button'),
                        'alignment'  => $this->container['gf_divi_fields']->get_selector('footer'),
                    ],
                    'box_shadow'    => [
                        'css' => [
                            'main' => $this->container['gf_divi_fields']->get_selector('button'),
                        ],
                    ],
                    'use_alignment' => true,
                    'hide_icon'     => true,
                    'text_color'    => [
                        'default' => '#ffffff',
                    ],
                ],
                'next_button'     => [
                    'label'         => 'Next Button',
                    'css'           => [
                        'main'       => $this->container['gf_divi_fields']->get_selector('next_button'),
                        'text_color' => $this->container['gf_divi_fields']->get_selector('next_button'),
                        'alignment'  => $this->container['gf_divi_fields']->get_selector('footer'),
                    ],
                    'box_shadow'    => [
                        'css' => [
                            'main' => 'html body ' . $this->container['gf_divi_fields']->get_selector('next_button'),
                        ],
                    ],
                    'use_alignment' => true,
                    'hide_icon'     => true,
                ],
                'previous_button' => [
                    'label'         => 'Previous Button',
                    'css'           => [
                        'main'       => $this->container['gf_divi_fields']->get_selector('previous_button'),
                        'text_color' => $this->container['gf_divi_fields']->get_selector('previous_button'),
                        'alignment'  => $this->container['gf_divi_fields']->get_selector('footer'),
                    ],
                    'box_shadow'    => [
                        'css' => [
                            'main' => 'html body ' . $this->container['gf_divi_fields']->get_selector('previous_button'),
                        ],
                    ],
                    'use_alignment' => true,
                    'hide_icon'     => true,
                ],
            ],
            'borders'        => [
                'default'       => [
                    'css'      => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element}",
                            'border_radii'  => "{$this->main_css_element}",
                        ],
                    ],
                    'defaults' => [
                        'border_radii'  => 'on||||',
                        'border_styles' => [
                            'width' => '0px',
                            'color' => '#ffffffff',
                            'style' => 'solid',
                        ],
                    ],
                ],
                'input_general' => [
                    'css'         => [
                        'main' => [
                            'border_styles' => $this->container['gf_divi_fields']->get_selector('input_border'),
                            'border_radii'  => $this->container['gf_divi_fields']->get_selector('input_border'),
                        ],
                    ],
                    'defaults'    => [
                        'border_radii'  => 'on||||',
                        'border_styles' => [
                            'width' => '1px',
                            'color' => '#bbbbbb',
                            'style' => 'solid',
                        ],
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'input_font',
                ],
            ],
            'text'           => false,
            'box_shadow'     => [
                'default'      => [
                    'css' => [
                        'main'      => "{$this->main_css_element}",
                        'important' => 'all',
                    ],
                ],
                'text_input'   => [
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('text_field') . ',' . $this->container['gf_divi_fields']->get_selector('textarea_field'),
                        'important' => 'all',
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'text_input',
                ],
                'select_field' => [
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('select_field'),
                        'important' => 'all',
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'select_field',
                ],
            ],
            'filters'        => [
                'css' => [
                    'main' => "{$this->main_css_element}",
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'custom_margin'  => false,
            'margin_padding' => [
                'css' => [
                    'main'      => "{$this->main_css_element}",
                    'important' => 'all',
                ],
            ],
            'background'     => [
                'css' => [
                    'main'      => "{$this->main_css_element}",
                    'important' => 'all',
                ],
            ],
            'fonts'          => [
                'title'                     => [
                    'sub_toggle'  => 'title',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('title'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#333333',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'font'        => [
                        'default' => '|700',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '22',
                    ],
                ],
                'description'               => [
                    'sub_toggle'  => 'description',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('description'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#666666',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'font'        => [
                        'default' => '',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                ],
                'label'                     => [
                    'sub_toggle'  => 'label',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('label'),
                        'important' => 'all',

                    ],
                    'font'        => [
                        'default' => '|700',
                    ],
                    'text_color'  => [
                        'default' => '#666666',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],

                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                ],
                'sub_label'                 => [
                    'sub_toggle'  => 'sub_label',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('sub_label'),
                        'important' => 'all',
                    ],
                    'text_color'  => [
                        'default' => '#666666',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '12',
                    ],
                ],
                'field_description'         => [
                    'sub_toggle'  => 'field_description',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('field_description'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#666666',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '12',
                    ],
                ],
                'input_font'                => [
                    'sub_toggle'  => 'input_font',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('input_general'),
                        'important' => 'all',

                    ],
                    'font'        => [
                    ],
                    'text_color'  => [
                        'default' => '#4e4e4e',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],

                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                ],
                'checkbox_radio_field'      => [
                    'sub_toggle'  => 'checkbox_radio_field',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('checkbox_radio_text'),
                        'important' => 'all',

                    ],
                    'font'        => [
                    ],
                    'text_color'  => [
                        'default' => '#4e4e4e',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],

                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                ],
                'placeholder'               => [
                    'css' => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('placeholder'),
                        'important' => 'all',

                    ],
                ],
                'list_column'               => [
                    'css' => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('list_column'),
                        'important' => 'all',

                    ],
                ],
                'consent_checkbox'          => [
                    'sub_toggle'  => 'consent_checkbox',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('consent_checkbox_label'),
                        'important' => 'all',

                    ],
                    'font'        => [
                    ],
                    'text_color'  => [
                        'default' => '#4e4e4e',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],

                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                ],
                'consent_description'       => [
                    'sub_toggle'  => 'consent_description',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('consent_description'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#666666',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                ],
                'validation_error_heading'  => [
                    'sub_toggle'  => 'validation_error_heading',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('validation_error_heading'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#790000',
                    ],
                    'text_align'  => [
                        'default' => 'center',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '14',
                    ],
                    'font'        => [
                        'default' => '|700',
                    ],
                ],
                'field_validation_error'    => [
                    'sub_toggle'  => 'field_validation_error',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('field_validation_error'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#790000',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '12',
                    ],
                    'font'        => [
                        'default' => '|700',
                    ],
                ],
                'confirmation_message'      => [
                    'sub_toggle'  => 'confirmation_message',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('confirmation_message'),
                        'important' => 'all',
                    ],
                    'text_color'  => [
                        'default' => '#000000',
                    ],
                    'text_align'  => [
                        'default' => 'center',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '20',
                    ],
                    'font'        => [
                        'default' => '|700',
                    ],
                ],
                'asterisk_text_legend'      => [
                    'css' => [
                        'main' => $this->container['gf_divi_fields']->get_selector('asterisk_text_legend'),
                    ],
                ],
                'progress_bar_title'        => [
                    'sub_toggle'  => 'progress_bar_title',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('progress_bar_title'),
                        'important' => 'all',
                    ],
                    'text_color'  => [
                        'default' => '#333333',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '12',
                    ],
                ],
                'section_field_title'       => [
                    'sub_toggle'  => 'section_field_title',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('section_field_title'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#333333',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'font'        => [
                        'default' => '|700',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '17',
                    ],

                ],
                'section_field_description' => [
                    'sub_toggle'  => 'section_field_title',
                    'css'         => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('section_field_description'),
                        'important' => 'all',

                    ],
                    'text_color'  => [
                        'default' => '#666666',
                    ],
                    'text_align'  => [
                        'default' => 'left',
                    ],
                    'font'        => [
                        'default' => '',
                    ],
                    'line_height' => [
                        'default' => '1',
                    ],
                    'font_size'   => [
                        'default' => '11',
                    ],

                ],
                'product_title'             => [
                    'label'               => esc_html__('Title', 'wp-tools-gravity-forms-divi-module'),
                    'depends_show_if'     => [],
                    'css'                 => [
                        'main'           => $this->container['gf_divi_fields']->get_selector('product_title'),
                        'font'           => $this->container['gf_divi_fields']->get_selector('product_title'),
                        'line_height'    => $this->container['gf_divi_fields']->get_selector('product_title'),
                        'color'          => $this->container['gf_divi_fields']->get_selector('product_title'),
                        'letter_spacing' => $this->container['gf_divi_fields']->get_selector('product_title'),
                        'text_align'     => $this->container['gf_divi_fields']->get_selector('product_title'),
                        'important'      => 'all',
                    ],
                    'use_all_caps'        => false,
                    'hide_text_shadow'    => false,
                    'hide_font'           => false,
                    'hide_font_size'      => false,
                    'hide_text_align'     => false,
                    'hide_letter_spacing' => false,
                    'hide_line_height'    => false,
                    'hide_text_color'     => false,

                    'font'                => [
                        'default' => '',
                    ],
                    'font_size'           => [
                        'default'        => '16px',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],
                    'text_color'          => [
                        'default' => '',
                    ],
                    'line_height'         => [
                        'default'        => '1em',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '10',
                            'step' => '0.1',
                        ],
                    ],

                    'letter_spacing'      => [
                        'default'        => '0px',
                        'range_settings' => [
                            'min'  => '0',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],

                    'text_align'          => [
                        'default' => 'left',
                    ],

                    'tab_slug'            => 'advanced',
                    'toggle_slug'         => 'product_title',
                ], //product_title
                'product_description'       => [
                    'label'               => esc_html__('Description', 'wp-tools-gravity-forms-divi-module'),
                    'depends_show_if'     => [],
                    'css'                 => [
                        'main'           => $this->container['gf_divi_fields']->get_selector('product_description'),
                        'font'           => $this->container['gf_divi_fields']->get_selector('product_description'),
                        'line_height'    => $this->container['gf_divi_fields']->get_selector('product_description'),
                        'color'          => $this->container['gf_divi_fields']->get_selector('product_description'),
                        'letter_spacing' => $this->container['gf_divi_fields']->get_selector('product_description'),
                        'text_align'     => $this->container['gf_divi_fields']->get_selector('product_description'),
                        'important'      => 'all',
                    ],
                    'use_all_caps'        => false,

                    'hide_text_shadow'    => false,
                    'hide_font'           => false,
                    'hide_font_size'      => false,
                    'hide_text_align'     => false,
                    'hide_letter_spacing' => false,
                    'hide_line_height'    => false,
                    'hide_text_color'     => false,

                    'font'                => [
                        'default' => '',
                    ],
                    'font_size'           => [
                        'default'        => '16px',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],
                    'text_color'          => [
                        'default' => '',
                    ],
                    'line_height'         => [
                        'default'        => '1em',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '10',
                            'step' => '0.1',
                        ],
                    ],

                    'letter_spacing'      => [
                        'default'        => '0px',
                        'range_settings' => [
                            'min'  => '0',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],

                    'text_align'          => [
                        'default' => 'left',
                    ],

                    'tab_slug'            => 'advanced',
                    'toggle_slug'         => 'product_description',
                ], //product_description
                'product_price_label'       => [
                    'label'               => esc_html__('Label', 'wp-tools-gravity-forms-divi-module'),
                    'depends_show_if'     => [],
                    'css'                 => [
                        'main'           => $this->container['gf_divi_fields']->get_selector('product_price_label'),
                        'font'           => $this->container['gf_divi_fields']->get_selector('product_price_label'),
                        'line_height'    => $this->container['gf_divi_fields']->get_selector('product_price_label'),
                        'color'          => $this->container['gf_divi_fields']->get_selector('product_price_label'),
                        'letter_spacing' => $this->container['gf_divi_fields']->get_selector('product_price_label'),
                        'text_align'     => $this->container['gf_divi_fields']->get_selector('product_price_label'),
                        'important'      => 'all',
                    ],
                    'use_all_caps'        => false,

                    'hide_text_shadow'    => false,
                    'hide_font'           => false,
                    'hide_font_size'      => false,
                    'hide_text_align'     => false,
                    'hide_letter_spacing' => false,
                    'hide_line_height'    => false,
                    'hide_text_color'     => false,

                    'font'                => [
                        'default' => '',
                    ],
                    'font_size'           => [
                        'default'        => '15px',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],
                    'text_color'          => [
                        'default' => '',
                    ],
                    'line_height'         => [
                        'default'        => '1em',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '10',
                            'step' => '0.1',
                        ],
                    ],

                    'letter_spacing'      => [
                        'default'        => '0px',
                        'range_settings' => [
                            'min'  => '0',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],

                    'text_align'          => [
                        'default' => 'left',
                    ],

                    'tab_slug'            => 'advanced',
                    'toggle_slug'         => 'product_price_label',
                ], //product_price_label
                'product_calculated_price'  => [
                    'label'               => esc_html__('Price', 'wp-tools-gravity-forms-divi-module'),
                    'depends_show_if'     => [],
                    'css'                 => [
                        'main'           => $this->container['gf_divi_fields']->get_selector('product_calculated_price'),
                        'font'           => $this->container['gf_divi_fields']->get_selector('product_calculated_price'),
                        'line_height'    => $this->container['gf_divi_fields']->get_selector('product_calculated_price'),
                        'color'          => $this->container['gf_divi_fields']->get_selector('product_calculated_price'),
                        'letter_spacing' => $this->container['gf_divi_fields']->get_selector('product_calculated_price'),
                        'text_align'     => $this->container['gf_divi_fields']->get_selector('product_calculated_price'),
                        'important'      => 'all',
                    ],
                    'use_all_caps'        => false,

                    'hide_text_shadow'    => false,
                    'hide_font'           => false,
                    'hide_font_size'      => false,
                    'hide_text_align'     => false,
                    'hide_letter_spacing' => false,
                    'hide_line_height'    => false,
                    'hide_text_color'     => false,

                    'font'                => [
                        'default' => '',
                    ],
                    'font_size'           => [
                        'default'        => '15px',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],
                    'text_color'          => [
                        'default' => '#900',
                    ],
                    'line_height'         => [
                        'default'        => '1em',
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '10',
                            'step' => '0.1',
                        ],
                    ],

                    'letter_spacing'      => [
                        'default'        => '0px',
                        'range_settings' => [
                            'min'  => '0',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],

                    'text_align'          => [
                        'default' => 'left',
                    ],

                    'tab_slug'            => 'advanced',
                    'toggle_slug'         => 'product_calculated_price',
                ], //product_calculated_price
                'field_asterisk'            => [
                    'label'               => esc_html__('&nbsp;', 'wp-tools-gravity-forms-divi-module'),
                    'css'                 => [
                        'main'      => $this->container['gf_divi_fields']->get_selector('field_asterisk'),
                        'important' => 'all',
                    ],
                    'use_all_caps'        => false,

                    'hide_text_shadow'    => false,
                    'hide_font'           => true,
                    'hide_font_size'      => false,
                    'hide_text_align'     => false,
                    'hide_letter_spacing' => false,
                    'hide_line_height'    => false,
                    'hide_text_color'     => true,

                    'font_size'           => [
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],
                    'line_height'         => [
                        'range_settings' => [
                            'min'  => '1',
                            'max'  => '10',
                            'step' => '0.1',
                        ],
                    ],

                    'letter_spacing'      => [
                        'range_settings' => [
                            'min'  => '0',
                            'max'  => '100',
                            'step' => '1',
                        ],
                        'validate_unit'  => true,
                    ],

                    'text_align'          => [
                    ],

                    'tab_slug'            => 'advanced',
                    'toggle_slug'         => 'asterisk',
                ],

            ], // end of fonts

            'link_options'   => false,
        ];
    }

    /**
     * Premium Custom css fields.
     *
     * @return [type] [description]
     */
    public function get_custom_css_fields_config()
    {
        return [
            'title'                    => [
                'label'    => esc_html__('Form Title', $this->container['slug']),
                'selector' => $this->container['gf_divi_fields']->get_selector('title'),
            ],
            'description'              => [
                'label'    => esc_html__('Form Description', $this->container['slug']),
                'selector' => $this->container['gf_divi_fields']->get_selector('description'),
            ],
            'label'                    => [
                'label'    => esc_html__('Label', $this->container['slug']),
                'selector' => $this->container['gf_divi_fields']->get_selector('label'),
            ],
            'sub_label'                => [
                'label'    => esc_html__('Sub Label', $this->container['slug']),
                'selector' => $this->container['gf_divi_fields']->get_selector('sub_label'),
            ],
            'field_description'        => [
                'label'    => esc_html__('Field Description', $this->container['slug']),
                'selector' => $this->container['gf_divi_fields']->get_selector('field_description'),
            ],
            'text_field'               => [
                'label'    => esc_html__('Text Field', $this->container['slug']),
                'selector' => $this->container['gf_divi_fields']->get_selector('text_field'),
            ],
            'textarea_field'           => [
                'label'    => esc_html__('Textarea Field', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('textarea_field'),
            ],
            'select_field'             => [
                'label'    => esc_html__('Select Field', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('select_field'),
            ],
            'checkbox_radio_field'     => [
                'label'    => esc_html__('Checkbox/Radio Field', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('checkbox_radio_input'),
            ],
            'checkbox_radio_text'      => [
                'label'    => esc_html__('Checkbox Radio Options Text', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('checkbox_radio_text'),
            ],
            'list_column'              => [
                'label'    => esc_html__('List Field Column', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('list_column'),
            ],
            'consent_checkbox_label'   => [
                'label'    => esc_html__('Consent Checkbox Label', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('consent_checkbox_label'),
            ],
            'consent_description'      => [
                'label'    => esc_html__('Consent Description', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('consent_description'),
            ],
            'validation_error_heading' => [
                'label'    => esc_html__('Validation Error Heading', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('validation_error_heading'),
            ],
            'validation_message'       => [
                'label'    => esc_html__('Field Validation Message', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('field_validation_error'),
            ],
            'button'                   => [
                'label'    => esc_html__('Button', $this->container['slug']),
                'selector' => "html body div#page-container .et_pb_section " . $this->container['gf_divi_fields']->get_selector('button'),
            ],
            'button_hover'             => [
                'label'    => esc_html__('Button Hover', $this->container['slug']),
                'selector' => "html body div#page-container .et_pb_section " . $this->container['gf_divi_fields']->get_selector('button_hover'),
            ],
            'confirmation_wrapper'     => [
                'label'    => esc_html__('Submitted Form Confirmation Wrapper', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('confirmation_wrapper'),
            ],
            'confirmation_message'     => [
                'label'    => esc_html__('Submitted Form Confirmation Message', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('confirmation_message'),
            ],
            'progress_bar_title'       => [
                'label'    => esc_html__('Progress Bar Title', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('progress_bar_title'),
            ],
            'progress_bar_percentage'  => [
                'label'    => esc_html__('Progress Bar Percentage', $this->container['slug']),
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('progress_bar_percentage'),
            ],
            'asterisk'                 => [
                'selector' => "html body div#page-container " . $this->container['gf_divi_fields']->get_selector('field_asterisk'),
                'label'    => 'Asterisk (Field)',
            ],
        ];

    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields()
    {
        $fields = $this->container['gf_divi_fields']->get_fields();

        return $fields;

    }

    /**
     * Get default for given keys
     */
    public function get_default($key)
    {
        return $this->container['gf_divi_fields']->get_default($key);

    }

    /**
     * Get the selector.
     */

    public function get_selector($key)
    {
        return $this->container['gf_divi_fields']->get_selector($key);

    }

    /**
     * Premium toggle options.
     */
    public function get_settings_modal_toggles()
    {
        $toggles                                       = [];
        $toggles['general']['toggles']['main_content'] = esc_html__('Shortcode Parameters', 'et_builder');

        $toggles['advanced'] = [
            'toggles' => [
                'title'                     => esc_html__('Form Title', 'et_builder'),
                'description'               => esc_html__('Form Description', 'et_builder'),
                'field_container'           => esc_html__('Field Wrapper', 'et_builder'),
                'label'                     => esc_html__('Label', 'et_builder'),
                'sub_label'                 => esc_html__('Sub Label', 'et_builder'),
                'field_description'         => esc_html__('Field Description', 'et_builder'),
                'input_container'           => esc_html__('Input Wrapper', 'et_builder'),
                'input_font'                => esc_html__('Input General', 'et_builder'),
                'text_input'                => esc_html__('Text/Textarea', 'et_builder'),
                'text_field'                => esc_html__('Text', 'et_builder'),
                'select_field'              => esc_html__('Select', 'et_builder'),
                'checkbox_radio_container'  => esc_html__('Checkbox/Radio Item Container', 'et_builder'),
                'checkbox_field'            => esc_html__('Checkbox', 'et_builder'),
                'radio_field'               => esc_html__('Radio', 'et_builder'),
                'checkbox_radio_field'      => esc_html__('Checkbox/Radio Text Option', 'et_builder'),
                'placeholder'               => esc_html__('Input Placeholder Text', 'et_builder'),
                'input_focus'               => esc_html__('Input Fields (On Focus)', 'et_builder'),
                'list_column'               => esc_html__('List Field Column Text', 'et_builder'),
                'section_field'             => esc_html__('Section Field Wrapper', 'et_builder'),
                'section_field_title'       => esc_html__('Section Field Title', 'et_builder'),
                'section_field_description' => esc_html__('Section Field Description', 'et_builder'),
                'consent_checkbox'          => esc_html__('Consent Checkbox', 'et_builder'),
                'consent_description'       => esc_html__('Consent Description', 'et_builder'),
                'date_dropdown_date_field'  => esc_html__('Date Drop Down & Date Field', 'et_builder'),
                'time_field'                => esc_html__('Time Field', 'et_builder'),
                'asterisk'                  => esc_html__('Asterisk', 'et_builder'),
                'asterisk_text_legend'      => esc_html__('Asterisk Text Legend', 'et_builder'),
                'validation_error_heading'  => esc_html__('Validation Error Heading', 'et_builder'),
                'field_validation_error'    => esc_html__('Field Validation Error', 'et_builder'),
                'footer'                    => esc_html__('Footer', 'et_builder'),
                'progress_bar_title'        => esc_html__('Progress Bar Title', 'et_builder'),
                'progress_bar'              => esc_html__('Progress Bar', 'et_builder'),
                'validation_error_field'    => esc_html__('Validation Error Field', 'et_builder'),
                'form_button'               => esc_html__('Button', 'et_builder'),
                'next_button'               => esc_html__('Next Button', 'et_builder'),
                'previous_button'           => esc_html__('Previous Button', 'et_builder'),
                'confirmation_message'      => esc_html__('Confirmation Message', 'et_builder'),
                'gf_left_half'              => esc_html__('gf_left_half - CSS Ready Class', 'et_builder'),
                'gf_left_middle_third'      => esc_html__('gf_left_third & gf_middle_third - CSS Ready Class', 'et_builder'),
                'product_title'             => esc_html__('Product Title', 'wp-tools-gravity-forms-divi-module'),
                'product_description'       => esc_html__('Product Description', 'wp-tools-gravity-forms-divi-module'),
                'product_price_label'       => esc_html__('Product Price Label', 'wp-tools-gravity-forms-divi-module'),
                'product_calculated_price'  => esc_html__('Product Calculated Price', 'wp-tools-gravity-forms-divi-module'),
            ],
        ];

        return $toggles;

    }

    public function init()
    {
        $this->icon_path = plugin_dir_path(__FILE__) . 'icon.svg';
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render(
        $unprocessed_props,
        $content = null,
        $render_slug = null
    ) {
        $module_classes = $this->module_classname($render_slug);
        $is_sticky      = strpos($module_classes, 'et_pb_sticky_module') !== false ?: false;

        $module_class = trim(ET_Builder_Element::add_module_order_class('', $render_slug));

        $defaults = wp_parse_args($unprocessed_props, $this->container['gf_divi_fields']->get_defaults());

        foreach ($defaults as $key => $value) {
            if (isset($this->props[$key]) and empty($this->props[$key])) {
                $this->props[$key] = $value;
            }
        }

        $props = wp_parse_args($this->props, $defaults);

        $this->container[$render_slug] = $props;

        $this->container['divi']->enqueue_et_pb_wpt_gravityform_assets();

        $main_selector = 'section.' . $module_class;

        $gravityform_id = $this->container['gravityform']->get_unprefixed_gravityform_id($props['gravityform_id']);

        $post_id = null;

        // phpcs:ignore WordPress.Security.NonceVerification
        if (wp_doing_ajax() && isset($_POST['options'], $_POST['options']['current_page'], $_POST['options']['current_page']['id'])) {
            // phpcs:ignore WordPress.Security.NonceVerification
            $post_id = (int) $_POST['options']['current_page']['id'];
        } else {
            global $post;
            if ($post) {
                $post_id = $post->ID;
            }
        }

        $gravityform_id = apply_filters('wpt_divi_gravity_form_id', $gravityform_id, $post_id);

        $gravityform_shortcode = sprintf(
            '[gravityform id=%1$s title=%2$s description=%3$s ajax=%4$s tabindex=%5$s field_values="%6$s"/]',
            $gravityform_id,
            $props['title'] == 'on' ? 'true' : 'false',
            $props['description'] == 'on' ? 'true' : 'false',
            $props['ajax'] == 'on' ? 'true' : 'false',
            $props['tabindex'],
            $props['field_values']
        );

        \ET_Builder_Element::set_style($render_slug, [
            'selector'    => $this->container['gf_divi_fields']->get_selector('description'),
            'declaration' => 'display:block;',
        ]);

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'title',
            $this->container['gf_divi_fields']->get_selector('title'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'description',
            $this->container['gf_divi_fields']->get_selector('description'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'field_container',
            $this->container['gf_divi_fields']->get_selector('field_container'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'label',
            $this->container['gf_divi_fields']->get_selector('label'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'sub_label',
            $this->container['gf_divi_fields']->get_selector('sub_label'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'input_container',
            "{$main_selector} div.gform_wrapper div.ginput_container",
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'field_description',
            $this->container['gf_divi_fields']->get_selector('field_description'),
            $render_slug
        );

        $text_input_selector = sprintf(
            '%s, %s',
            $this->container['gf_divi_fields']->get_selector('text_field'),
            $this->container['gf_divi_fields']->get_selector('textarea_field')
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'text_input',
            $text_input_selector,
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'select_field',
            $this->container['gf_divi_fields']->get_selector('select_field'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'checkbox_radio_field',
            $this->container['gf_divi_fields']->get_selector('checkbox_radio_option_container'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'asterisk_text_legend',
            $this->container['gf_divi_fields']->get_selector('asterisk_text_legend'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'consent_checkbox',
            $this->container['gf_divi_fields']->get_selector('consent_container'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'consent_description',
            $this->container['gf_divi_fields']->get_selector('consent_description'),
            $render_slug
        );

        $validation_error_heading_selector = $this->container['gf_divi_fields']->get_selector('validation_error_container');

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'validation_error_heading',
            $validation_error_heading_selector,
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'progress_bar_title',
            $this->container['gf_divi_fields']->get_selector('progress_bar_title'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'field_validation_error',
            $this->container['gf_divi_fields']->get_selector('field_validation_error'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'footer',
            $this->container['gf_divi_fields']->get_selector('footer'),
            $render_slug
        );

        // css ready classes

        // gf_left_half
        $gf_left_half_padding_responsive_values = $this->container['divi']->get_responsive_values('gf_left_half_padding_right', $props, $this->get_default('gf_left_half_padding_right'));

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->get_selector('gf_left_half'),
                'declaration' => sprintf('padding-right:%s !important;', $gf_left_half_padding_responsive_values['phone']),
                'media_query' => '@media only screen and ( max-width: 640px )',
            ]
        );

        unset($gf_left_half_padding_responsive_values['phone']);
        et_pb_responsive_options()->generate_responsive_css($gf_left_half_padding_responsive_values, $this->get_selector('gf_left_half'), 'padding-right', $render_slug, ' !important;', 'select');

        //gf middle and left third

        $gf_left_middle_third_padding_right_responsive_values = $this->container['divi']->get_responsive_values('gf_left_middle_third_padding_right', $props, $this->get_default('gf_left_middle_third_padding_right'));

        ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->get_selector('gf_left_third_gf_middle_third'),
                'declaration' => sprintf('padding-right:%s !important;', $gf_left_middle_third_padding_right_responsive_values['phone']),
                'media_query' => '@media only screen and ( max-width: 640px )',
            ]
        );

        unset($gf_left_middle_third_padding_right_responsive_values['phone']);
        et_pb_responsive_options()->generate_responsive_css($gf_left_middle_third_padding_right_responsive_values, $this->get_selector('gf_left_third_gf_middle_third'), 'padding-right', $render_slug, ' !important;', 'select');

        // ET_Builder_Element::set_style(
        //     $render_slug,
        //     [
        //         'selector'    => $this->get_selector('gf_left_third_gf_middle_third'),
        //         'declaration' => sprintf('padding-right:%s !important;', $props['gf_left_middle_third_padding_right']),
        //     ]
        // );

        if (isset($props['validation_error_heading_text_color'])) {
            ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => $validation_error_heading_selector,
                    'declaration' => sprintf('border-color:%s;', $props['validation_error_heading_text_color']),
                ]
            );
        }

        \ET_Builder_Element::set_style($render_slug, [
            'selector'    => "$main_selector .gfield.gfield_error, $main_selector .gform_wrapper .gfield_error input:not([type='radio']):not([type='checkbox']):not([type='submit']):not([type='button']):not([type='image']):not([type='file']), $main_selector .gform_wrapper .gfield_error textarea",
            'declaration' => sprintf('border-color:%s;', $props['field_validation_border_color']),
        ]);

        if ($props['field_validation_error_background_color']) {
            \ET_Builder_Element::set_style($render_slug, [
                'selector'    => $this->container['gf_divi_fields']->get_selector('error_field_container'),
                'declaration' => sprintf('background-color:%s;', $props['field_validation_error_background_color']),
            ]);
        }

        \ET_Builder_Element::set_style($render_slug, [
            'selector'    => $text_input_selector . ", " . $this->container['gf_divi_fields']->get_selector('select_field'),
            'declaration' => sprintf('background-color:%s;', $props['text_input_bg_color']),
        ]);

        // button : gf 2.6+ footer is css flex.
        $button_alignment_values = $this->container['divi']->get_responsive_values('form_button_alignment', $props, 'left');

        foreach ($button_alignment_values as $device => $value) {
            $new_value = '';
            switch ($value) {
                case 'right':
                    $new_value = 'flex-end';
                    break;

                case 'left':
                    $new_value = 'flex-start';
                    break;

                case 'center':
                    $new_value = 'center';
                    break;

                default:
                    $new_value = 'flex-start';
                    break;
            }

            $button_alignment_values[$device] = $new_value;
        }

        et_pb_responsive_options()->generate_responsive_css($button_alignment_values, $this->get_selector('footer'), 'justify-content', $render_slug, ' !important;', 'select');

        ET_Builder_Element::set_style(
            $render_slug, [
                'selector'    => $this->container['gf_divi_fields']->get_selector('button'),
                'declaration' => sprintf(
                    'cursor:pointer;'
                ),
            ]
        );

        \ET_Builder_Element::set_style($render_slug, [
            'selector'    => $this->container['gf_divi_fields']->get_selector('confirmation_wrapper'),
            'declaration' => sprintf('background-color:%s;', $props['confirmation_message_background_color']),
        ]);

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'confirmation_message',
            $this->container['gf_divi_fields']->get_selector('confirmation_wrapper'),
            $render_slug
        );

        $progress_bar_selector = $this->container['gf_divi_fields']->get_selector('progress_bar_percentage');

        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $progress_bar_selector,
                'declaration' => sprintf(
                    'color:%s;background-color:%s;',
                    $props['progress_bar_text_color'],
                    $props['progress_bar_color']
                ),
            ]);

        // section fields
        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'section_field_title',
            $this->container['gf_divi_fields']->get_selector('section_field_title'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'section_field_description',
            $this->container['gf_divi_fields']->get_selector('section_field_description'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'section_field',
            $this->container['gf_divi_fields']->get_selector('section_field'),
            $render_slug
        );

        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'checkbox_radio_option_text',
            $this->container['gf_divi_fields']->get_selector('checkbox_radio_text'),
            $render_slug
        );

        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->container['gf_divi_fields']->get_selector('section_field'),
                'declaration' => sprintf('border-bottom-color:%s', $props['section_field_border_color']),
            ]
        );
        // section fields

        if (!isset($props['custom_form_button']) || ($props['custom_form_button'] == 'off')) {
            $this->set_button_default_on_custom_disabled__premium_only($render_slug, $main_selector);
        }

        // checkbox input fix
        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => "{$main_selector} .gform_wrapper .gfield_checkbox .gchoice input[type='checkbox'], {$main_selector} .gform_wrapper .ginput_container_consent input[type='checkbox']",
                'declaration' => 'vertical-align:middle;',
            ]
        );
        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => "{$main_selector} .gform_wrapper .gfield_radio input[type='radio']",
                'declaration' => 'vertical-align:middle;',
            ]
        );

        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->container['gf_divi_fields']->get_selector('gf_date_dropdown_date_field'),
                'declaration' => sprintf('margin-right:%s !important;', $props['date_field_margin_right']),
            ]
        );

        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->container['gf_divi_fields']->get_selector('ampm_dropdown_field'),
                'declaration' => sprintf('margin-left:%s !important;', $props['ampm_field_margin_left']),
            ]
        );

        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->container['gf_divi_fields']->get_selector('time_fields'),
                'declaration' => sprintf('min-width:%s !important;', $props['time_field_min_width']),
            ]
        );

        \ET_Builder_Element::set_style(
            $render_slug,
            [
                'selector'    => $this->container['gf_divi_fields']->get_selector('asterisk'),
                'declaration' => sprintf('color:%s;', $props['asterisk_color']),
            ]
        );

        if ($props['form_error_background']) {
            \ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => $this->container['gf_divi_fields']->get_selector('validation_error_heading') . ',' . $this->container['gf_divi_fields']->get_selector('validation_error_container'),
                    'declaration' => sprintf('background:%s;', $props['form_error_background']),
                ]
            );
        }

        if ($props['checkbox_change_size'] == 'on') {
            \ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => $this->container['gf_divi_fields']->get_selector('checkbox_field'),
                    'declaration' => sprintf('height:%1$s;width:%1$s;', $props['checkbox_size']),
                ]
            );
        }

        if ($props['radio_change_size'] == 'on') {
            \ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => $this->container['gf_divi_fields']->get_selector('radio_field'),
                    'declaration' => sprintf('height:%1$s;width:%1$s;', $props['radio_size']),
                ]
            );
        }

        // select field height
        if ($props['set_select_height'] == 'on') {
            $select_field_height_values = $this->container['divi']->get_responsive_values('select_field_height', $props, $this->get_default('select_field_height'));

            foreach ($select_field_height_values as $device => $value) {
                if ($value === '0px') {
                    $select_field_height_values[$device] = 'inherit';
                }
            }

            et_pb_responsive_options()->generate_responsive_css($select_field_height_values, $this->get_selector('select_field'), 'height', $render_slug, ' !important;', 'select');
        }
        // text field height
        if ($props['set_text_height'] == 'on') {
            $text_field_height_values = $this->container['divi']->get_responsive_values('text_field_height', $props, $this->get_default('text_field_height'));

            foreach ($text_field_height_values as $device => $value) {
                if ($value === '0px') {
                    $text_field_height_values[$device] = 'inherit';
                }
            }

            et_pb_responsive_options()->generate_responsive_css($text_field_height_values, $this->get_selector('text_field'), 'height', $render_slug, ' !important;', 'select');
        }

        // Checked option styling
        if ($props['enable_checked_option_styling'] == 'on') {

            \ET_Builder_Element::set_style(
                $render_slug,
                [
                    'selector'    => sprintf('%s , %s', $this->get_selector('checked_checkbox_option_text'), $this->get_selector('checked_radio_option_text')),
                    'declaration' => sprintf('color:%s !important;', $props['checked_option_text_color']),
                ]
            );
        }

        ob_start();
        require $this->container['dir'] . '/resources/views/et_pb_wpt_gravityform.php';
        return ob_get_clean();
    }

    /**
     * Default button style when advanced styles are off.
     */
    public function set_button_default_on_custom_disabled__premium_only(
        $render_slug,
        $main_selector
    ) {
        ET_Builder_Element::set_style(
            $render_slug, [
                'selector'    => $this->container['gf_divi_fields']->get_selector('button'),
                'declaration' => sprintf(
                    'cursor:pointer; padding: 0.3em 1em !important; font-size: 20px !important; color:#ffffff; background:#000000;border-radius: 3px; border: 2px solid #000000;'
                ),
            ]
        );
    }
}
